!include "MUI2.nsh"
!include "fileassoc.nsh"

!include "FileFunc.nsh"
!define UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\{0E470839-3EC7-4C70-B8DD-055724B9F569}"

!define VERSION "1.0"

Name "Collision Mask Utilities V${VERSION}"
OutFile "Mask_Utilities_Setup.exe"
 
RequestExecutionLevel admin

InstallDir "$PROGRAMFILES\Collision Mask Utilities\"
 
!define MUI_ABORTWARNING
 
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "licence.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

!insertmacro MUI_LANGUAGE "English"


Section "Application" secFiles
	SetOutPath $INSTDIR
	
	File "..\build-CollisionMaskUtilities-Desktop_Qt_5_3_0_MSVC2010_OpenGL_32bit-Release\CollisionMaskCreator\release\CollisionMaskCreator.exe"
	File "..\build-CollisionMaskUtilities-Desktop_Qt_5_3_0_MSVC2010_OpenGL_32bit-Release\CollisionMaskViewer\release\CollisionMaskViewer.exe"
	
	# Dependencies
	File "C:\Qt\5.3\msvc2010_opengl\bin\icudt52.dll"
	File "C:\Qt\5.3\msvc2010_opengl\bin\icuin52.dll"
	File "C:\Qt\5.3\msvc2010_opengl\bin\icuuc52.dll"
	File "C:\Qt\5.3\msvc2010_opengl\bin\Qt5Core.dll"
	File "C:\Qt\5.3\msvc2010_opengl\bin\Qt5Gui.dll"
	File "C:\Qt\5.3\msvc2010_opengl\bin\Qt5Widgets.dll"
	CreateDirectory "platforms"
	SetOutPath $INSTDIR\platforms
	File "C:\Qt\5.3\msvc2010_opengl\plugins\platforms\qwindows.dll"
	SetOutPath $INSTDIR
	
	# Visual C++ 2010 Redistributable
	File "vcredist_x86.exe"
	ExecWait "$INSTDIR\vcredist_x86.exe /passive /showfinalerror"
	Delete "$INSTDIR\vcredist_x86.exe"
	
	WriteRegStr HKLM "${UNINST_KEY}" "DisplayName" "Collision Mask Utilities"
	WriteRegStr HKLM "${UNINST_KEY}" "Publisher" "David Powell"
	WriteRegStr HKLM "${UNINST_KEY}" "DisplayIcon" "$INSTDIR\CollisionMaskCreator.exe"
	WriteRegStr HKLM "${UNINST_KEY}" "DisplayVersion" "${VERSION}"
	WriteRegStr HKLM "${UNINST_KEY}" "URLInfoAbout" "http://www.loadcode.co.uk"
	WriteRegStr HKLM "${UNINST_KEY}" "UninstallString" "$\"$INSTDIR\uninstall.exe$\""
	
	${GetSize} "$INSTDIR" "/S=0K" $0 $1 $2
	IntFmt $0 "0x%08X" $0
	WriteRegDWORD HKLM "${UNINST_KEY}" "EstimatedSize" "$0"
	
	SetShellVarContext all	
	CreateDirectory "$SMPROGRAMS\Collision Mask Utilities"
	CreateShortCut "$SMPROGRAMS\Collision Mask Utilities\Collision Mask Creator.lnk" "$INSTDIR\CollisionMaskCreator.exe"
	CreateShortCut "$SMPROGRAMS\Collision Mask Utilities\Collision Mask Viewer.lnk" "$INSTDIR\CollisionMaskViewer.exe"
	CreateShortCut "$SMPROGRAMS\Collision Mask Utilities\Uninstall.lnk" "$INSTDIR\uninstall.exe"
	WriteUninstaller "$INSTDIR\uninstall.exe"
	
	!insertmacro APP_ASSOCIATE "cmsk" "CollisionMaskViewer.CMSK" "Collision Mask" \
		"$INSTDIR\CollisionMaskViewer.exe,1" "Open with Collision Mask Viewer" "$INSTDIR\CollisionMaskViewer.exe $\"%1$\""

	!insertmacro UPDATEFILEASSOC
SectionEnd

Section "Desktop Shortcuts" SecDesktopShortcut
	SetShellVarContext all
	CreateShortCut "$DESKTOP\Collision Mask Creator.lnk" "$INSTDIR\CollisionMaskCreator.exe"
	CreateShortCut "$DESKTOP\Collision Mask Viewer.lnk" "$INSTDIR\CollisionMaskViewer.exe"
SectionEnd

Section "un.Desktop Shortcuts"
	SetShellVarContext all
	Delete "$DESKTOP\Collision Mask Creator.lnk"
	Delete "$DESKTOP\Collision Mask Viewer.lnk"
SectionEnd

Section "Source Code" SecSourceCode
	CreateDirectory "$INSTDIR\Source Code"
	SetOutPath "$INSTDIR\Source Code"
	File /r /x *.user "..\CollisionMaskUtilities"
	File /r /x *.exe /x Dependencies "..\Windows Installer"
	
	SetOutPath "$INSTDIR\Source Code\Windows Installer"
	File "..\Windows Installer\vcredist_x86.exe"
	
	SetOutPath "$INSTDIR\Source Code"
	File /r "..\Linux Packages"
	CreateShortCut "$SMPROGRAMS\Collision Mask Utilities\Source Code.lnk" "$INSTDIR\Source Code"
SectionEnd

Section "un.Source Code"
	RMDir /r "$INSTDIR\Source Code"
	Delete "$SMPROGRAMS\Collision Mask Utilities\Source Code.lnk"
SectionEnd

;Descriptions
	;Language strings
	LangString DESC_SecFiles ${LANG_ENGLISH} "Files required to use the software. (compulsory)"
	LangString DESC_SecDesktopShortcut ${LANG_ENGLISH} "Place icons on the desktop."
	LangString DESC_SecSourceCode ${LANG_ENGLISH} "The source code."
 
	;Assign language strings to sections
	!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
		!insertmacro MUI_DESCRIPTION_TEXT ${SecFiles} $(DESC_SecFiles)
		!insertmacro MUI_DESCRIPTION_TEXT ${SecDesktopShortcut} $(DESC_SecDesktopShortcut)
		!insertmacro MUI_DESCRIPTION_TEXT ${SecSourceCode} $(DESC_SecSourceCode)
	!insertmacro MUI_FUNCTION_DESCRIPTION_END

Section "Uninstall"
	!insertmacro APP_UNASSOCIATE "cmsk" "CollisionMaskViewer.CMSK"
	!insertmacro UPDATEFILEASSOC
	
	RMDir /r /REBOOTOK $INSTDIR
	
	DeleteRegKey HKLM "${UNINST_KEY}"
  
	SetShellVarContext all
	Delete "$SMPROGRAMS\Collision Mask Utilities\Uninstall.lnk"
	Delete "$SMPROGRAMS\Collision Mask Utilities\Collision Mask Creator.lnk"
	Delete "$SMPROGRAMS\Collision Mask Utilities\Collision Mask Viewer.lnk"
	Delete "$SMPROGRAMS\Collision Mask Utilities\ReadMe.lnk"
	RMDir "$SMPROGRAMS\Collision Mask Utilities"
SectionEnd

Function .onInit
	SectionSetFlags ${SecFiles} 17

	ReadRegStr $R0 HKLM "${UNINST_KEY}" "UninstallString"
	StrCmp $R0 "" done
 
	ReadRegStr $R1 HKLM "${UNINST_KEY}" "DisplayVersion" 
	
	MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
		"Collision Mask Utilities version $R1 is installed. $\n$\nClick OK to replace it with \
		version ${VERSION} or Cancel to abort." \
		IDOK uninst
	Abort

	;Run the uninstaller
	uninst:
		ExecWait "$R0 /S"
		
	done:
FunctionEnd
